/*****************************************************************************/
/*                         Freescale Semiconductor                           */
/*****************************************************************************/
/* File Type: Header                                                         */
/* File Name: Colors.h                                                       */
/* Description: HEX code of colors for RGB 565 TFT displays                  */
/* Author: Jos Santiago Lpez Ramrez                                       */
/* Date: 04/10/10                                                            */
/* Version: 2.0                                                              */
/*****************************************************************************/

#include "FslTypes.h"

#ifndef _COLORS_H_
  #define _COLORS_H_

/*****************************************************************************/
/*                          Bit Color Definitions                            */
/*****************************************************************************/

    #define Black       0x00,0x00,0x00 //RGB for color black
    #define White       0xFF,0xFF,0xFF //RGB for color white
    #define Red         0xFF,0x00,0x00 //RGB for color red
    #define Green       0x00,0xFF,0x00 //RGB for color green
    #define Blue        0x00,0x00,0xFF //RGB for color blue
    #define Darkblue    0x00,0x80,0xFF
    #define Lightblue   0x33,0xCC,0xFF
    #define LEMONGREEN  0x66,0xFF,0x00
    #define LIGHTBROWN  0xE6,0xCB,0xAD
    
    #define LOWBYTE     0
    #define HIGHBYTE    1

/*****************************************************************************/
/*                                Functions                                  */
/*****************************************************************************/
    
    /**
     * \brief  This function converts 888 color mode into 565 color mode
     * \author Jos Santiago Lpez Ramrez
     * \param  UINT8 Rcomp: Red 8Bits Component
     * \param  UINT8 Gcomp: Green 8Bits Component
     * \param  UINT8 Bcomp: Blue 8Bits Component
     * \param  UINT8 ReturnByte: Byte to be returned 0=565LB 1=565HB
     * \return 565 Color low or high byte (depending on ReturnByte value)
     * \todo   
     * \warning 
     */
     extern UINT8 Convert_888_to_565 (UINT8 Rcomp, UINT8 Gcomp, UINT8 Bcomp, UINT8 ReturnByte);
  
#endif